 ; Ŀ
 ;   Shutdown - read a cdf file into a shutdown key block.                 
 ;   Copyright 1996, 2003, 2004 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Csv - read a cdf file into an association list assuming that the      
 ;   first element of each sublist matches the cell name in the            
 ;   spreadsheet that the file came from - columns are A - Z - AA etc.,    
 ;   rows are 1 - n.                                                       
 ;   Takes one argument - the name of the file to read.                    
 ;   Returns the association list.                                         
 ; 
 (DEFUN CSV (csvfil / fn num linn chnum llist chbase charc gnulst sub gnusub
                                                                      master)
 ; Ŀ
 ;   If a file name was given and the file can be opened.                  
 ; 
  (if (and csvfil (setq fn (open csvfil "r")))
      (progn
           (setq num 0)
 ; Ŀ
 ;   The main loop - while there are lines in the data file.               
 ; 
           (while (setq linn (read-line fn))
                  (grtext -2 (setq chnum (itoa (setq num (1+ num)))))
 ; Ŀ
 ;   Read the next line into a list of strings.                            
 ; 
                  (setq llist (csplit linn))
 ; Ŀ
 ;   Now make the string list into an association list.  Each value        
 ;   corresponds to a cell in the original spreadsheet, and the            
 ;   association code matches the cell name.                               
 ;   Cells are named alphabetically by column and numerically by row:      
 ;   the first row is 1, the first column is A, so the upper left cell     
 ;   is A1.  Z1 is followed by AA1.                                        
 ; 
                  (setq chbase "")
                  (setq charc "A")
                  (setq gnulst ())
                  (while (setq sub (car llist))
                         (setq llist (cdr llist))
                         (if (/= sub "")
                             (progn
                                  (setq gnusub (list (strcat chbase charc
                                                                   chnum) sub))
                                  (setq gnulst (append gnulst (list gnusub)))))
                         (if (< charc "Z")
                             (setq charc (chr (1+ (ascii charc))))
                             (progn
                                (setq charc "A")
                                (if (= chbase "")
                                    (setq chbase "A")
                                    (setq chbase (chr (1+ (ascii chbase))))))))
                  (if gnulst
                      (setq master (append master gnulst))))))
 master)
 ; Ŀ
 ;   Csv end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Csplit - divide a text string at commas, make into a list  
 ;   of substrings.                                                        
 ; 
 (DEFUN CSPLIT (linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) ",")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Csplit end.                                                           
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without the path.                   
 ; 
 (DEFUN NOPATH ( / tt pos ff)
 ; Ŀ
 ;   Get drawing name with path and set pointer Pos to end of string.      
 ; 
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ;  and set pos to first
         (setq pos (1- pos)))                       ; set pos to previous
  tt)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Plort - error handler.                                                
 ; 
 (DEFUN PLORT (shk /)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Plort end.                                                            
 ; 

 ; Ŀ
 ;   Mint - Convert seconds to hours, minutes and seconds.                 
 ; 
 (DEFUN MINT (sec / hours mins)
  (setq hours (itoa (fix (/ sec 3600))))
  (setq sec (rem sec 3600))
  (setq mins (itoa (fix (/ sec 60))))
  (setq sec (itoa (fix (rem sec 60))))
  (if (= (strlen hours) 1) (setq hours (strcat "0" hours)))
  (if (= (strlen mins) 1) (setq mins (strcat "0" mins)))
  (if (= (strlen sec) 1) (setq sec (strcat "0" sec)))
  (strcat hours ":" mins ":" sec))
 ; Ŀ
 ;   Mint end.                                                             
 ; 

 ; Ŀ
 ;   Since - print the time since the start time returned since the time   
 ;   passed as the sole variable.                                          
 ;   Returns nothing, calls Mint.                                          
 ; 
 (DEFUN SINCE (t1 / s t2 elapse timea timlft)
 ; Ŀ
 ;   T1 = start time, Totnum = total drawings, Done = drawings finished    
 ; 
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (setq elapse (- t2 t1))
 ; Ŀ
 ;   Write the elapsed time.                                               
 ; 
  (write-line (strcat "\nElapsed time: " (mint elapse)))
 (princ))
 ; Ŀ
 ;   Since end.                                                            
 ; 
 

 ; Ŀ
 ;   Shutdown.                                                             
 ; 
 (DEFUN C:SHUTDOWN (/ esav csvfil enam s start master num entt tagnam newt)
  (setvar "cmdecho" 0)
  (command ".undo" "M")
 ; Ŀ
 ;   Initialize new error handler, save and reset sysvars.                 
 ; 
  (setq esav *error*)
  (setq *error* plort)
  (command ".attdisp" "n")
 ; Ŀ
 ;   Find the Shutdown block, ask for a name if none.                      
 ; 
  (if (or (setq ss (ssget "X" (list (cons 2 "IN*OUT*"))))
          (setq ss (ssget "X" (list (cons 2 "OUT*IN*"))))
          (setq ss (ssget "X" (list (cons 2 "ROCSDK2"))))
          (setq ss (ssget "X" (list (cons 2 "IN1OUT1-BANYAN"))))
          (setq ss (ssget "X" (list (cons 2 "*IN*OUT-PCP"))))
          (setq ss (ssget "X" (list (cons 2 "PCP-IN*OUT*"))))
 ; Oi's new Encana Alderson block.
          (setq ss (ssget "X" (list (cons 2 "Ald-in*out*"))))
 ; Another new Oi block for Alderson System 1, 13-21.
          (setq ss (ssget "X" (list (cons 2 "Ald-1-in*out*"))))
 ; The Devon SDK to fit the Devon border.  Mostly identical to the new
 ; standard Gemini SDK but with fewer rows and columns.
          (setq ss (ssget "X" (list (cons 2 "Devon In*-Out*"))))
 ; Brians new Gemini/Pcp blocks.
          (setq ss (ssget "X" (list (cons 2 "Pcp3-in*out*"))))
 ; Original and new Kilowatts blocks.
          (setq ss (ssget "X" (list (cons 2 "KwIn1Out1"))))
          (setq ss (ssget "X" (list (cons 2 "In*Out*-kw"))))
 ; Rigel blocks (For Reg?)
          (setq ss (ssget "X" (list (cons 2 "In1Out1-Rigel"))))
          (setq ss (ssget "X" (list (cons 2 "In2Out1-Rigel"))))
 ; Abdul's wacko Pcp block for Tide Lake.
          (setq ss (ssget "X" (list (cons 2 "Odd-In1Out1"))))
 ; Steve's new Penn West block for Roxana.
          (setq ss (ssget "X" (list (cons 2 "Pfister*"))))
 ; Suzanne's odd block: Cassils?  Alderson?
          (setq ss (ssget "X" (list (cons 2 "Tutu_1-1"))))
          (setq ss (ssget "X" (list (cons 2 "Tutu_2-1"))))
 ; Cam's new block for BC Gas.  Just this once.  Really.
          (setq ss (ssget "X" (list (cons 2 "BC Gas In*-Out*"))))
 ; Abdul's new Gemini standard with extra wide columns.  There were probably
 ; creatures who complained during the Cambrian Explosion.
          (setq ss (ssget "X" (list (cons 2 "In*-Out*"))))
 ; Abdul's new Eagle Butte SDK.  (Not really his fault.)
          (setq ss (ssget "X" (list (cons 2 "Eagle-In*Out*"))))
 ; The new Rangeland Encana SDK.
          (setq ss (ssget "X" (list (cons 2 "Rangeland-In*Out*"))))
 ; The new renamed Rangeland Encana SDK.
          (setq ss (ssget "X" (list (cons 2 "Rangeland Encana In*Out*")))))
      (progn
           (setq enam (setq esav (ssname ss 0)))
           (setq blnam (cdr (assoc 2 (entget enam))))
           (write-line (strcat "Shutdown block found: " blnam)))
      (setq enam (setq esav (car (entsel "Select SDK block: ")))))
 ; Ŀ
 ;   Get data file name and prompt for data block selection.               
 ; 
  (setq csvnam (strcat (nopath) ".csv"))
  (if (setq csvfil (findfile csvnam))
      (setq csvnam csvfil)
      (setq csvnam ""))
  (if (and enam (setq csvfil (getfiled "Select cdf/csv data file"
                                        csvnam "" 4)))
      (progn
 ; Ŀ
 ;   Save the start time.                                                  
 ; 
           (setq s (getvar "date"))
           (setq start (* 86400.0 (- s (fix s))))     ; start time for timer
 ; Ŀ
 ;   Call subroutine Csv to open the data file and make the master list.   
 ; 
           (setq master (csv csvfil))
 ; Ŀ
 ;   Step through the attributes in the block and install the data.        
 ; 
           (setq num 0)
           (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                  (grtext -2 (itoa (setq num (1+ num))))
                  (setq tagnam (cdr (assoc 2 entt)))
                  (setq newt (cadr (assoc tagnam master)))
 ; Ŀ
 ;   Allow for special case characters.                                    
 ; 
                  (cond ((null newt) (setq newt ""))
                        ((= (ascii newt) 214) (setq newt "X")))
                  (if newt (entmod (subst (cons 1 newt) (assoc 1 entt) entt))))
 ; Ŀ
 ;   Update the block.                                                     
 ; 
           (entupd esav)))
 ; Ŀ
 ;   Reset sysvars, print elapsed time, and end.                           
 ; 
  (since start)
  (setq *error* esav)
 (princ))